unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Clipbrd, ExtCtrls, ComCtrls, IniFiles, ShellApi, Math;

type
  TForm1 = class(TForm)
    StatusBar: TStatusBar;
    GroupBox1: TGroupBox;
    GroupBox2: TGroupBox;
    GroupBox3: TGroupBox;
    Label2: TLabel;
    Label3: TLabel;
    txbWgetParams: TEdit;
    txbMapServer: TEdit;
    rbCorners: TRadioButton;
    Label1: TLabel;
    txbLeftBottom: TEdit;
    Label5: TLabel;
    txbRightTop: TEdit;
    rbCenter: TRadioButton;
    Label6: TLabel;
    txbCenter: TEdit;
    Panel1: TPanel;
    rbBlocks: TRadioButton;
    rbKilometers: TRadioButton;
    txbWidth: TEdit;
    txbHeight: TEdit;
    Label7: TLabel;
    rbCoords: TRadioButton;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    txbStartX: TEdit;
    Label13: TLabel;
    txbAvaiableLayers: TMemo;
    Label14: TLabel;
    txbSelectedLayers: TEdit;
    Label15: TLabel;
    Label16: TLabel;
    Label17: TLabel;
    GroupBox5: TGroupBox;
    btnRunMapGen: TButton;
    txbStartY: TEdit;
    txbStopX: TEdit;
    txbStopY: TEdit;
    SaveDialog: TSaveDialog;
    GroupBox6: TGroupBox;
    TrackBar: TTrackBar;
    Label8: TLabel;
    lblDetail: TLabel;
    txbMapName: TEdit;
    Label18: TLabel;
    chkResample: TCheckBox;
    Label4: TLabel;
    Label19: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure TrackBarChange(Sender: TObject);
    procedure btnRunMapGenClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure rbCornersClick(Sender: TObject);
  private
    function CreateMapGenIni: Integer;
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// ********************** MAPGEN *************************
const
  IWidth = 256;
  IHeight = 256;
  CygWinPath = 'cygwin\';

var
  DefIni: TIniFile;
  MapLevel: Integer;
  MapSkip: Integer;
  StartX, StopX, StartY, StopY: Integer;
  JpegUsed: Boolean;
  ResultFormatOzi: string;


function HexToInt(HexStr: String): Integer;
begin
  result := StrToIntDef('$' + HexStr, 0);
end;


function MapRound(Coord: Int64; Ref: Int64): Int64;
begin
  Result := Coord - (Coord mod Ref);
end;

procedure GenDownload;
var
  ActiveMaps: string;
  S: string;
  Name: string;
  F, Cmd: TextFile;
  X, Y: Integer;
begin
  // Write('Generuji skript a seznam souboru ke stazeni... ');
  ActiveMaps := Form1.txbSelectedLayers.Text + ',';
  AssignFile(Cmd, 'mapgen1_download.cmd');
  ReWrite(Cmd);
  WriteLn(Cmd, '@mkdir resultmap');
  repeat
    S := Copy(ActiveMaps, 1, Pos(',', ActiveMaps) - 1);
    Name := DefIni.ReadString('Base' + S, 'Name', 'base');
    AssignFile(F, Format('base_%s.txt', [Name]));
    ReWrite(F);
    for X := 0 to (StopX - StartX) div MapSkip do begin
      for Y := 0 to (StopY - StartY) div MapSkip do begin
        WriteLn(F, LowerCase(Format('%s%s/%d_%.7x_%.7x', [
          Form1.txbMapServer.Text,
          Name,
          MapLevel,
          StartX + X * MapSkip,
          StartY + Y * MapSkip
        ])));
      end;
    end;
    CloseFile(F);
    WriteLn(Cmd, Format('@mkdir base_%s', [Name]));
    WriteLn(Cmd, Format('@cd base_%s', [Name]));
    WriteLn(Cmd, Format('..\%swget.exe %s --input-file=../base_%s.txt', [
      CygWinPath,
      Form1.txbWgetParams.Text,
      Name
    ]));
    WriteLn(Cmd, '@cd ..');
    Delete(ActiveMaps, 1, Pos(',', ActiveMaps));
  until Pos(',', ActiveMaps) = 0;
  CloseFile(Cmd);
end;

procedure GenConvertOverlay;
var
  ActiveMaps: string;
  S: string;
  Name, ImgFormat, BaseName, BaseImgFormat: string;
  Cmd: TextFile;
  X, Y: Integer;
begin
  // Write('Generuji skript pro konverzi a prolozeni vrstev... ');
  AssignFile(Cmd, 'mapgen2_overlay.cmd');
  ReWrite(Cmd);

  ActiveMaps := Form1.txbSelectedLayers.Text + ',';
  S := Copy(ActiveMaps, 1, Pos(',', ActiveMaps) - 1);
  BaseName := DefIni.ReadString('Base' + S, 'Name', 'base');
  BaseImgFormat := DefIni.ReadString('Base' + S, 'ImgFormat', 'gif');
  JpegUsed := (BaseImgFormat = 'jpeg');
  Delete(ActiveMaps, 1, Pos(',', ActiveMaps));

  for X := 0 to (StopX - StartX) div MapSkip do begin
    for Y := 0 to (StopY - StartY) div MapSkip do begin
      { konverze }
      WriteLn(Cmd, Format('%s%stopnm.exe base_%s/%d_%.7x_%.7x > img_baseimage.pnm', [
        CygWinPath, BaseImgFormat,
        BaseName, MapLevel, StartX + X * MapSkip, StartY + Y * MapSkip,
        Name
      ]));
      WriteLn(Cmd, Format('if errorlevel 1 (%spbmmake.exe -white 256 256 > img_baseimage.pnm)', [
        CygWinPath
      ]));
      S := ActiveMaps;
      while Pos(',', S) <> 0 do begin
        Name := DefIni.ReadString('Base' + Copy(S, 1, Pos(',', S) - 1), 'Name', 'base');
        ImgFormat := DefIni.ReadString('Base' + Copy(S, 1, Pos(',', S) - 1), 'ImgFormat', 'gif');
        if ImgFormat = 'jpeg' then JpegUsed := True;

        WriteLn(Cmd, Format('%s%stopnm.exe base_%s/%d_%.7x_%.7x > img_%s.pnm', [
          CygWinPath, ImgFormat,
          Name, MapLevel, StartX + X * MapSkip, StartY + Y * MapSkip,
          Name
        ]));
        WriteLn(Cmd, Format('%s%stopnm.exe -alpha base_%s/%d_%.7x_%.7x > img_%s_alpha.pnm', [
          CygWinPath, ImgFormat,
          Name, MapLevel, StartX + X * MapSkip, StartY + Y * MapSkip,
          Name
        ]));

        Delete(S, 1, Pos(',', S));
      end;

      { prokladani }
      S := ActiveMaps;
      while Pos(',', S) <> 0 do begin
        Name := DefIni.ReadString('Base' + Copy(S, 1, Pos(',', S) - 1), 'Name', 'base');

        WriteLn(Cmd, Format('%spnmcomp.exe -alpha=img_%s_alpha.pnm img_%s.pnm img_baseimage.pnm img_result.pnm', [
          CygWinPath, Name, Name
        ]));
        WriteLn(Cmd, Format('@del img_%s_alpha.pnm', [Name]));
        WriteLn(Cmd, Format('@del img_%s.pnm', [Name]));
        WriteLn(Cmd, '@del img_baseimage.pnm');
        WriteLn(Cmd, '@ren img_result.pnm img_baseimage.pnm');

        Delete(S, 1, Pos(',', S));
      end;

      WriteLn(Cmd, Format('move img_baseimage.pnm resultmap\%d_%.7x_%.7x.pnm', [
          MapLevel, StartX + X * MapSkip, StartY + Y * MapSkip
      ]));
    end;
  end;
  CloseFile(Cmd);
end;

procedure GenConcat;
var
  ActiveMaps: string;
  Cmd: TextFile;
  X, Y: Integer;
  S: string;
  BaseName: string;
begin
  // Write('Generuji skript pro spojeni ctvercu mapy... ');
  AssignFile(Cmd, 'mapgen3_concat.cmd');
  ReWrite(Cmd);

  ActiveMaps := Form1.txbSelectedLayers.Text + ',';
  S := Copy(ActiveMaps, 1, Pos(',', ActiveMaps) - 1);
  BaseName := DefIni.ReadString('Base' + S, 'Name', 'base');

  for Y := 0 to (StopY - StartY) div MapSkip do begin
    Write(Cmd, Format('%spnmcat.exe -lr ', [CygWinPath]));
    for X := 0 to (StopX - StartX) div MapSkip do begin
      Write(Cmd, Format('resultmap/%d_%.7x_%.7x.pnm ', [MapLevel, StartX + X * MapSkip, StartY + Y * MapSkip]));
    end;
    WriteLn(Cmd, Format('> line_%.7x.pnm', [StartY + Y * MapSkip]));
  end;

  Write(Cmd, Format('%spnmcat.exe -tb ', [CygWinPath]));
  for Y := (StopY - StartY) div MapSkip downto 0 do begin
    Write(Cmd, Format('line_%.7x.pnm ', [StartY + Y * MapSkip]));
  end;
  WriteLn(Cmd, Format('> resultmap.pnm', []));

  WriteLn(Cmd, '@del /Q line_*.pnm');

  CloseFile(Cmd);
end;

procedure GenConvert2;
var
  Cmd: TextFile;
  MapName: string;
  ResultFormat: string;
begin
  // Write('Generuji skript pro konverzi mapy... ');
  AssignFile(Cmd, 'mapgen4_convert.cmd');
  ReWrite(Cmd);
  MapName := Form1.txbMapName.Text;

  if JpegUsed then begin
    ResultFormat := 'jpeg';
    ResultFormatOzi := 'jpg';
    WriteLn(Cmd, Format('ren resultmap.pnm %s.pnm', [MapName]));
  end else begin
    ResultFormat := 'png';
    ResultFormatOzi := 'png';
    if Form1.chkResample.Checked then begin
      WriteLn(Cmd, Format('%spnmcolormap.exe 256 resultmap.pnm > resultmap_map.pnm', [CygWinPath]));
      WriteLn(Cmd, Format('%spnmremap.exe -mapfile=resultmap_map.pnm resultmap.pnm > %s.pnm', [CygWinPath, MapName]));
    end else begin
      WriteLn(Cmd, Format('ren resultmap.pnm %s.pnm', [MapName]));
    end;
  end;

  WriteLn(Cmd, Format('%spnmto%s.exe %s.pnm > %s.%s', [CygWinPath, ResultFormat, MapName, MapName, ResultFormatOzi]));

  WriteLn(Cmd, '@del /Q resultmap.pnm');
  WriteLn(Cmd, '@del /Q resultmap_map.pnm');
  WriteLn(Cmd, Format('@del /Q %s.pnm', [MapName]));

  CloseFile(Cmd);
end;

procedure GenMapFile;
var
  F: TextFile;
  UTM_X1, UTM_X2, UTM_Y1, UTM_Y2: Integer;
  J: Integer;
  MapName: string;
begin
  // Write('Generuji MAP soubor... ');
  MapName := Form1.txbMapName.Text;
  AssignFile(F, MapName + '.map');
  ReWrite(F);
  WriteLn(F, 'OziExplorer Map Data File Version 2.2');
  WriteLn(F, MapName);
  WriteLn(F, MapName + '.' + ResultFormatOzi);
  WriteLn(F, '1 ,Map Code,');
  WriteLn(F, 'WGS 84,WGS 84,   0.0000,   0.0000,WGS 84');
  WriteLn(F, 'Reserved 1');
  WriteLn(F, 'Reserved 2');
  WriteLn(F, 'Magnetic Variation,,,E');
  WriteLn(F, 'Map Projection,(UTM) Universal Transverse Mercator,PolyCal,No,AutoCalOnly,No,BSBUseWPX,No');

  UTM_X1 := StartX div 32 - 3700000;
  UTM_X2 := (StopX+MapSkip) div 32 - 3700000;
  UTM_Y1 := StartY div 32 + 1300000;
  UTM_Y2 := (StopY+MapSkip) div 32 + 1300000;

  WriteLn(F, Format('Point%.02d,xy,%5d,%5d,in, deg,    ,        ,N,    ,        ,W, grid, 33,%11d,%11d,N',
                    [1, 0, 0,
                     UTM_X1, UTM_Y2]));
  WriteLn(F, Format('Point%.02d,xy,%5d,%5d,in, deg,    ,        ,N,    ,        ,W, grid, 33,%11d,%11d,N',
                    [2, ((StopX - StartX) div MapSkip + 1) * IWidth - 1, ((StopY - StartY) div MapSkip + 1) * IHeight - 1,
                     UTM_X2, UTM_Y1]));

  for J := 3 to 30 do
    WriteLn(F, Format('Point%.02d,xy,     ,     ,in, deg,    ,        ,N,    ,        ,W, grid,   ,           ,           ,N', [J]));

  WriteLn(F, 'Projection Setup,,,,,,,,,,');
  WriteLn(F, 'Map Feature = MF ; Map Comment = MC     These follow if they exist');
  WriteLn(F, 'Track File = TF      These follow if they exist');
  WriteLn(F, 'Moving Map Parameters = MM?    These follow if they exist');
  CloseFile(F);
end;

procedure GenBatch;
var
  Cmd: TextFile;
begin
  AssignFile(Cmd, 'do_mapgen.cmd');
  ReWrite(Cmd);
  WriteLn(Cmd, '@call mapgen1_download.cmd');
  WriteLn(Cmd, '@call mapgen2_overlay.cmd');
  WriteLn(Cmd, '@call mapgen3_concat.cmd');
  WriteLn(Cmd, '@call mapgen4_convert.cmd');
  CloseFile(Cmd);
end;

procedure GenPROCEED;
begin
  GenDownload;
  GenConvertOverlay;
  GenConcat;
  GenConvert2;
  GenBatch;
  GenMapFile;
end;

procedure LLtoUTM(Lat, Long: Double; var UTMNorthing, UTMEasting: Double; var UTMZone: string);
 {converts lat/long to UTM coords.  Equations from USGS Bulletin 1532
  East Longitudes are positive, West longitudes are negative.
  North latitudes are positive, South latitudes are negative
  Lat and Long are in decimal degrees
	Written by Chuck Gantz- chuck.gantz@globalstar.com }

const
  PI = 3.14159265;

  { WGS-84 reference system parameters }
  wa = 6378137;
  eccSquared = 0.00669438;
  k0 = 0.9996;

var
  deg2rad: Double;

	LongOrigin: Double;
	eccPrimeSquared: Double;
	N, T, C, A, M: Double;

 {Make sure the longitude is between -180.00 .. 179.9 }
	LongTemp: Double;

	LatRad: Double;
	LongRad: Double;
	LongOriginRad: Double;
	ZoneNumber: Integer;

begin
  deg2rad := PI / 180;

	LongTemp := Long; // (Long+180)-Round((Long+180)/360)*360-180; { -180.00 .. 179.9; }
	LatRad := Lat*deg2rad;
	LongRad := LongTemp*deg2rad;


//	ZoneNumber := Round((LongTemp + 180)/6) + 1;
//
//	if (Lat >= 56.0) and (Lat < 64.0) and (LongTemp >= 3.0) and (LongTemp < 12.0) then
//		ZoneNumber := 32;
//
//  { Special zones for Svalbard }
//	if (Lat >= 72.0) and (Lat < 84.0) then begin
//	  if(      LongTemp >= 0.0)  and (LongTemp <  9.0 ) then ZoneNumber := 31
//	  else if( LongTemp >= 9.0)  and (LongTemp < 21.0 ) then ZoneNumber := 33
//	  else if( LongTemp >= 21.0) and (LongTemp < 33.0 ) then ZoneNumber := 35
// 	  else if( LongTemp >= 33.0) and (LongTemp < 42.0 ) then ZoneNumber := 37;
//  end;
  ZoneNumber := 33;
	LongOrigin := (ZoneNumber - 1)*6 - 180 + 3;  {+3 puts origin in middle of zone }
	LongOriginRad := LongOrigin * deg2rad;

	{compute the UTM Zone from the latitude and longitude }
//  UTMZone := Format('%d%c', [ZoneNumber, UTMLetterDesignator(Lat)]);

	eccPrimeSquared := (eccSquared)/(1-eccSquared);

	N := wa/sqrt(1-eccSquared*sin(LatRad)*sin(LatRad));
	T := tan(LatRad)*tan(LatRad);
	C := eccPrimeSquared*cos(LatRad)*cos(LatRad);
	A := cos(LatRad)*(LongRad-LongOriginRad);

	M := wa*((1 - eccSquared/4 - 3*eccSquared*eccSquared/64 - 5*eccSquared*eccSquared*eccSquared/256)*LatRad
				- (3*eccSquared/8 + 3*eccSquared*eccSquared/32 + 45*eccSquared*eccSquared*eccSquared/1024)*sin(2*LatRad)
				+ (15*eccSquared*eccSquared/256 + 45*eccSquared*eccSquared*eccSquared/1024)*sin(4*LatRad)
				- (35*eccSquared*eccSquared*eccSquared/3072)*sin(6*LatRad));

	UTMEasting := (k0*N*(A+(1-T+C)*A*A*A/6
					+ (5-18*T+T*T+72*C-58*eccPrimeSquared)*A*A*A*A*A/120)
					+ 500000.0);

	UTMNorthing := (k0*(M+N*tan(LatRad)*(A*A/2+(5-T+9*C+4*C*C)*A*A*A*A/24
				 + (61-58*T+T*T+600*C-330*eccPrimeSquared)*A*A*A*A*A*A/720)));
	if (Lat < 0) then
		UTMNorthing := UTMNorthing + 10000000.0; { 10000000 meter offset for southern hemisphere }
end;

procedure LLtoUTM_my(Long, Lat: Double; var X, Y: Integer);
var
  N, E: Double;
  Z: string;
begin
  LLtoUTM(Lat, Long, N, E, Z);
  Y := (Round(N)-1300000)*32;
  X := (Round(E)+3700000)*32;
end;



// ********************** GUI *************************
procedure TForm1.FormCreate(Sender: TObject);
var
  S: string;
  I: Integer;
begin
  DefIni := TIniFile.Create(ExtractFilePath(Application.ExeName) + 'mapgen.ini');
  txbMapServer.Text := DefIni.ReadString('Config', 'Server', '');
  txbWgetParams.Text := DefIni.ReadString('Config', 'WgetParams', '');
  chkResample.Checked := DefIni.ReadBool('Config', 'Png256ColorResample', True);
  I := 0;
  txbAvaiableLayers.Lines.Clear;
  TrackBarChange(Self);
  repeat
    S := DefIni.ReadString('Base' + IntToStr(I), 'Desc', '');
    if S <> '' then begin
      txbAvaiableLayers.Lines.Add(Format('%d = %s', [I, S]));
    end;
    Inc(I);
  until S = '';

  txbSelectedLayers.Text := DefIni.ReadString('Saved', 'ActiveMaps', '');
  txbMapName.Text := DefIni.ReadString('Saved', 'MapName', 'Mapa');
  TrackBar.Position := 18 - DefIni.ReadInteger('Saved', 'MapLevel', 13);
  case DefIni.ReadInteger('Saved', 'CornersCenterCoords', 0) of
    1: rbCenter.Checked := True;
    2: rbCoords.Checked := True;
    else rbCorners.Checked := True;
  end;
  rbCornersClick(Sender);
  txbLeftBottom.Text := DefIni.ReadString('Saved', 'LinkLeftBottom', '');
  txbRightTop.Text := DefIni.ReadString('Saved', 'LinkRightTop', '');
  txbCenter.Text := DefIni.ReadString('Saved', 'LinkCenter', '');
  txbWidth.Text := DefIni.ReadString('Saved', 'Width', '1');
  txbHeight.Text := DefIni.ReadString('Saved', 'Height', '1');
  case DefIni.ReadInteger('Saved', 'BlockKilometers', 0) of
    1: rbKilometers.Checked := True;
    else rbBlocks.Checked := True;
  end;
  txbStartX.Text := DefIni.ReadString('Saved', 'StartX', '');
  txbStartY.Text := DefIni.ReadString('Saved', 'StartY', '');
  txbStopX.Text := DefIni.ReadString('Saved', 'StopX', '');
  txbStopY.Text := DefIni.ReadString('Saved', 'StopY', '');
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  DefIni.WriteString('Config', 'Server', txbMapServer.Text);
  DefIni.WriteString('Config', 'WgetParams', txbWgetParams.Text);
  DefIni.WriteBool('Config', 'Png256ColorResample', chkResample.Checked);

  DefIni.WriteString('Saved', 'ActiveMaps', txbSelectedLayers.Text);
  DefIni.WriteString('Saved', 'MapName', txbMapName.Text);
  DefIni.WriteInteger('Saved', 'MapLevel', 18 - TrackBar.Position);
  if rbCenter.Checked then DefIni.WriteInteger('Saved', 'CornersCenterCoords', 1)
  else if rbCoords.Checked then DefIni.WriteInteger('Saved', 'CornersCenterCoords', 2)
  else DefIni.WriteInteger('Saved', 'CornersCenterCoords', 0);
  DefIni.WriteString('Saved', 'LinkLeftBottom', txbLeftBottom.Text);
  DefIni.WriteString('Saved', 'LinkRightTop', txbRightTop.Text);
  DefIni.WriteString('Saved', 'LinkCenter', txbCenter.Text);
  DefIni.WriteString('Saved', 'Width', txbWidth.Text);
  DefIni.WriteString('Saved', 'Height', txbHeight.Text);
  if rbKilometers.Checked then DefIni.WriteInteger('Saved', 'BlockKilometers', 1)
  else DefIni.WriteInteger('Saved', 'BlockKilometers', 0);
  DefIni.WriteString('Saved', 'StartX', txbStartX.Text);
  DefIni.WriteString('Saved', 'StartY', txbStartY.Text);
  DefIni.WriteString('Saved', 'StopX', txbStopX.Text);
  DefIni.WriteString('Saved', 'StopY', txbStopY.Text);

  DefIni.Free;
end;

function TForm1.CreateMapGenIni: Integer;
var
  C1, C2: string;
  X, Y: Integer;
  sX, sY: string;
  SiX, SiY: Integer;
begin
  MapLevel := StrToInt(lblDetail.Caption);
  MapSkip := (1 shl (28 - MapLevel));
  Result := 0;

  if rbCorners.Checked then begin
    C1 := txbLeftBottom.Text;
    C2 := txbRightTop.Text;

    sX := Copy(C1, Pos('#x=', C1) + 3, Pos('&y=', C1) - Pos('#x=', C1) - 3);
    sY := Copy(C1, Pos('&y=', C1) + 3, Pos('&z=', C1) - Pos('&y=', C1) - 3);
    if Pos('.', sX) <> 0 then sX[Pos('.', sX)] := DecimalSeparator;
    if Pos('.', sY) <> 0 then sY[Pos('.', sY)] := DecimalSeparator;
    LLtoUTM_my(StrToFloat(sX), StrToFloat(sY), X, Y);
    StartX := MapRound(X, MapSkip);
    StartY := MapRound(Y, MapSkip);

    sX := Copy(C2, Pos('#x=', C2) + 3, Pos('&y=', C2) - Pos('#x=', C2) - 3);
    sY := Copy(C2, Pos('&y=', C2) + 3, Pos('&z=', C2) - Pos('&y=', C2) - 3);
    if Pos('.', sX) <> 0 then sX[Pos('.', sX)] := DecimalSeparator;
    if Pos('.', sY) <> 0 then sY[Pos('.', sY)] := DecimalSeparator;
    LLtoUTM_my(StrToFloat(sX), StrToFloat(sY), X, Y);
    StopX := MapRound(X, MapSkip);
    StopY := MapRound(Y, MapSkip);

  end else if rbCenter.Checked then begin
    C1 := txbCenter.Text;

    sX := Copy(C1, Pos('#x=', C1) + 3, Pos('&y=', C1) - Pos('#x=', C1) - 3);
    sY := Copy(C1, Pos('&y=', C1) + 3, Pos('&z=', C1) - Pos('&y=', C1) - 3);
    if Pos('.', sX) <> 0 then sX[Pos('.', sX)] := DecimalSeparator;
    if Pos('.', sY) <> 0 then sY[Pos('.', sY)] := DecimalSeparator;
    LLtoUTM_my(StrToFloat(sX), StrToFloat(sY), X, Y);

    if rbBlocks.Checked then begin
      SiX := StrToIntDef(txbWidth.Text, 0) * MapSkip;
      SiY := StrToIntDef(txbHeight.Text, 0) * MapSkip;
    end else if rbKilometers.Checked then begin
      SiX := StrToIntDef(txbWidth.Text, 0) * 32000;
      SiY := StrToIntDef(txbHeight.Text, 0) * 32000;
    end else Exit;

    StartX := MapRound(X - SiX div 2, MapSkip);
    StartY := MapRound(Y - SiY div 2, MapSkip);
    StopX := MapRound(X + SiX div 2, MapSkip);
    StopY := MapRound(Y + SiY div 2, MapSkip);

  end else if rbCoords.Checked then begin
    StartX := MapRound(HexToInt(txbStartX.Text), MapSkip);
    StopX := MapRound(HexToInt(txbStopX.Text), MapSkip);
    StartY := MapRound(HexToInt(txbStartY.Text), MapSkip);
    StopY := MapRound(HexToInt(txbStopY.Text), MapSkip);

  end else Exit;

  Result := ((StopX - StartX) div MapSkip + 1) * ((StopY - StartY) div MapSkip + 1);

  GenPROCEED;
end;

procedure TForm1.TrackBarChange(Sender: TObject);
begin
  lblDetail.Caption := IntToStr(18 - TrackBar.Position);
end;

procedure TForm1.btnRunMapGenClick(Sender: TObject);
var
  Cnt: Integer;
begin
  Cnt := CreateMapGenIni;

  if (Cnt = 0) then begin
    Application.MessageBox(PChar('Chyba generovn (0 tverc). Opravte zadn!'), 'MapGen', MB_OK);
    Exit;
  end;

  if (Cnt > 100*100) then
    if Application.MessageBox(PChar('Pozor, vsledn mapa velice rozshl (' + IntToStr(Cnt) + ' tverc)! Pokraovat?'), 'MapGen', MB_YESNO) <> IDYES then
      Exit;

  if Application.MessageBox(PChar('MapGen pipraven (' + IntToStr(Cnt) + ' tverc). Spustit operaci?'), 'MapGen', MB_YESNO) <> IDYES then
    Exit;

  ShellExecute(Handle, 'open', 'cmd.exe', '/c do_mapgen.cmd', nil, SW_SHOWNORMAL);
end;

procedure TForm1.rbCornersClick(Sender: TObject);
var
  B: Boolean;
begin
  B := rbCorners.Checked;
  txbLeftBottom.Enabled := B;
  txbRightTop.Enabled := B;
  Label1.Enabled := B;
  Label5.Enabled := B;

  B := rbCenter.Checked;
  Label6.Enabled := B;
  txbCenter.Enabled := B;
  rbBlocks.Enabled := B;
  rbKilometers.Enabled := B;
  Label7.Enabled := B;
  txbWidth.Enabled := B;
  txbHeight.Enabled := B;

  B := rbCoords.Checked;
  Label9.Enabled := B;
  Label10.Enabled := B;
  Label11.Enabled := B;
  Label12.Enabled := B;
  txbStartX.Enabled := B;
  txbStartY.Enabled := B;
  txbStopX.Enabled := B;
  txbStopY.Enabled := B;
end;

end.

